% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{quarto_publish}
\alias{quarto_publish}
\title{Publish to RStudio Connect}
\usage{
quarto_publish(
  input = ".",
  name = NULL,
  method = c("rsconnect"),
  server = NULL,
  account = NULL,
  render = TRUE,
  launch_browser = interactive()
)
}
\arguments{
\item{input}{The input file or project directory to be published. Defaults to
current working directory.}

\item{name}{Name for publishing (names must be unique within an account). For
projects, defaults to the \code{name} provided by the project (alternatively
uses the base name of the \code{input}).}

\item{method}{Publishing method (currently only "rsconnect" is available)}

\item{server}{Server name. Required only if you use the same account name on
multiple servers.}

\item{account}{Account to deploy to. This parameter is only required for the
initial deployment when there are multiple accounts configured on the
system.}

\item{render}{\code{TRUE} to render locally before publishing.}

\item{launch_browser}{If \code{TRUE}, the system's default web browser will be
launched automatically after deployment. Defaults to \code{TRUE} in interactive
sessions only.}
}
\description{
Publish a quarto document or project to RStudio Connect
}
\examples{
\dontrun{
library(quarto)
quarto_publish()
}

}
