% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{make.product}
\alias{make.product}
\title{Make Product Terms (e.g., interactions)}
\usage{
make.product(
  data,
  x.nm,
  m.nm,
  center.x = FALSE,
  center.m = FALSE,
  scale.x = FALSE,
  scale.m = FALSE,
  suffix.x = "",
  suffix.m = "",
  sep = ":",
  combo = TRUE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{x.nm}{character vector of colnames from \code{data} specifying the
predictor columns.}

\item{m.nm}{character vector of colnames from \code{data} specifying the
moderator columns.}

\item{center.x}{logical vector of length 1 specifying whether the predictor
columns should be grand-mean centered before making the product terms.}

\item{center.m}{logical vector of length 1 specifying whether the moderator
columns should be grand-mean centered before making the product terms.}

\item{scale.x}{logical vector of length 1 specifying whether the predictor
columns should be grand-SD scaled before making the product terms.}

\item{scale.m}{logical vector of length 1 specifying whether the moderator
columns should be grand-SD scaled before making the product terms.}

\item{suffix.x}{character vector of length 1 specifying any suffix to add to
the end of the predictor colnames \code{x.nm} when creating the colnames of
the return object.}

\item{suffix.m}{character vector of length 1 specifying any suffix to add to
the end of the moderator colnames \code{m.nm} when creating the colnames of
the return object.}

\item{sep}{character vector of length 1 specifying the string to connect
\code{x.nm} and \code{m.nm} when specifying the colnames of the return
object.}

\item{combo}{logical vector of length 1 specifying whether all combinations
of the predictors and moderators should be calculated or only those in
parallel to each other (i.e., \code{x.nm[i]} and \code{m.nm[i]}). This
argument is only applicable when multiple predictors AND multiple
moderators are given.}
}
\value{
data.frame with product terms (e.g., interactions) as columns. The
  colnames are created by \code{paste(paste0(x.nm, suffix.x), paste0(m.nm,
  suffix.m), sep = sep)}.
}
\description{
\code{make.product} creates product terms (i.e., interactions) from various
components. \code{make.product} uses \code{Center} for the optional of
centering and/or scaling the predictors and/or moderators before making the
product terms.
}
\examples{
make.product(data = attitude, x.nm = c("complaints","privileges"),
   m.nm = "learning", center.x = TRUE, center.m = TRUE,
   suffix.x = "_c", suffix.m = "_c") # with grand-mean centering
make.product(data = attitude, x.nm = c("complaints","privileges"),
   m.nm = c("learning","raises"), combo = TRUE) # all possible combinations
make.product(data = attitude, x.nm = c("complaints","privileges"),
   m.nm = c("learning","raises"), combo = FALSE) # only combinations "in parallel"
}
