% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/l.R
\name{l}
\alias{l}
\title{Label features}
\usage{
l(qmap_obj, field = NULL, layer = 1)
}
\arguments{
\item{qmap_obj}{a qmap object from which to pull the labels.  Raster layers
are ignored.  Will also accept \code{sp} objects.}

\item{field}{a field in the sp object to use to label the features.  Defaults
to row.names().}

\item{layer}{identify which sp layer to label.  Defaults to first layer
       in qmap_obj$map_data.}
}
\description{
It is useful to be able to provide labels to features on your map when
examining the results of given analysis.  This function adds labels for a
given layer (currently just point or polygon layers).
}
\examples{
\dontrun{
data(lake)
qm<-qmap(lake,width,buffer)
l(qm,'COMID')
l(qm, layer = 2)
l(qm, layer = "buffer")
}
}

