% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcurves.R
\name{plotcurves}
\alias{plotcurves}
\title{Plot the curves}
\usage{
plotcurves(qp, panel = NULL, xpanel = NULL, ypanel = NULL, color = NULL,
  averages = T, curves = T, thresholds = T, ci = T)
}
\arguments{
\item{qp}{output from quickpsy}

\item{panel}{Name of the variable to be split in panels.}

\item{xpanel}{Name of the variable to be split in horizontal panels.}

\item{ypanel}{Name of the variable to be split in vertical panels.}

\item{color}{Name of the variable codded by color.}

\item{averages}{If \code{FALSE} averaged probabilities are not plotted
(default is \code{TRUE}).}

\item{curves}{If \code{FALSE} curves are not plotted
(default is \code{TRUE})}

\item{thresholds}{If \code{FALSE} thresholds  are not plotted
(default is \code{TRUE})}

\item{ci}{If \code{FALSE} confidence intervals are not plotted
(default is \code{TRUE})}
}
\description{
\code{plotcurves} plot the curves.
}
\examples{
library(MPDiR) # contains the Vernier data
fit <- quickpsy(Vernier, Phaseshift, NumUpward, N,
                grouping = .(Direction, WaveForm, TempFreq), B = 5)
plotcurves(fit)
plotcurves(fit, xpanel = Direction)
plotcurves(fit, xpanel = Direction, color = WaveForm, ci = FALSE)
}
\seealso{
\code{\link{plotcurves_}}
}

