% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.InteractionClassification.R
\name{mse}
\alias{mse}
\title{Mean Squared Errors for Interaction Classification}
\usage{
mse(object, ...)
}
\arguments{
\item{object}{An object of class \code{InteractionClassification} containing
the classified data and clustering results.}

\item{...}{Additional arguments passed to other methods (currently not used).}
}
\value{
A list containing the MSE for viral load differences
(\code{vlogs_mse}) and CD4 count differences (\code{cds_mse}).
}
\description{
Mean squared errors (MSE) for viral load differences
and CD4 count differences by comparing the actual values with the group means
from the classification.
}
\examples{
data(vl_3)
data(cd_3)
interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)
mse(class_obj)

}
