% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_demo.R
\docType{data}
\name{overwrite_demo}
\alias{overwrite_demo}
\title{A demonstration dataset used to overwrite specific entity names or sectors}
\format{
\code{overwrite_demo} is a \link{data.frame} with columns:
\itemize{
\item \code{id_2dii} (character): IDs of the entities to overwrite.
\item \code{level} (character): Which level should be overwritten (e.g.
direct_loantaker or ultimate_parent).
\item \code{name} (character): Overwrite name (if only overwriting sector, type NA).
\item \code{sector} (character): Overwrite sector (if only overwriting name, type NA).
\item \code{source} (character): What is the source of this information (leave as
"manual" for now, may remove this flag later).
}
}
\usage{
overwrite_demo
}
\description{
Fake dataset used to manually link loanbook entities to mismatched asset
level entities.

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://2degrees-investing.org/resource/pacta/}).
}
\examples{
head(overwrite_demo)
}
\seealso{
\link{data_dictionary}

Other demo datasets: 
\code{\link{ald_demo}},
\code{\link{loanbook_demo}}
}
\concept{demo datasets}
\keyword{datasets}
