% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_RunJitter.R
\name{SS_RunJitter}
\alias{SS_RunJitter}
\title{Iteratively apply the jitter option in SS}
\usage{
SS_RunJitter(mydir, model = "ss3",
  extras = "-nohess -cbs 500000000 -gbs 500000000", Njitter, Intern = TRUE,
  systemcmd = FALSE, printlikes = TRUE)
}
\arguments{
\item{mydir}{Directory where model files are located}

\item{model}{Executable name}

\item{extras}{Additional command line arguments passed to executable}

\item{Njitter}{Number of jitters, or a vector of jitter iterations.
If \code{length(Njitter) > 1} only the iterations specified will be ran,
else \code{1:Njitter} will be executed.}

\item{Intern}{Show command line info in R console or keep hidden (Internal=TRUE)}

\item{systemcmd}{Option to switch between 'shell' and 'system'}

\item{printlikes}{Print likelihood values to console}
}
\value{
A vector of likelihoods for each jitter iteration.
}
\description{
Iteratively runs SS model with different jittered starting parameter values
(jitter value must be mannually set in starter.ss). Output files are renamed
in the format Report1.sso, Report2.sso, etc.
}
\author{
James T. Thorson, Kelli F. Johnson
}

