% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotMovementMap.R
\name{SSplotMovementMap}
\alias{SSplotMovementMap}
\title{Show movement rates on a map.}
\usage{
SSplotMovementMap(replist = NULL, xlim, ylim, polygonlist, colvec,
  land = "grey", xytable = NULL, moveage = 5, moveseas = 1,
  lwdscale = 5, legend = TRUE, title = NULL, areanames = NULL,
  cex = 1)
}
\arguments{
\item{replist}{optional list created by \code{\link{SS_output}}}

\item{xlim}{range of longitude values in the map}

\item{ylim}{range of latitude values in the map}

\item{polygonlist}{a list of data frames, each with two columns representing
the longitude and latitude values of the colored polygons. The order of
elements in the list should match the numbering of areas in the SS model.}

\item{colvec}{vector of colors for each polygon (if \code{replist} is
provided)}

\item{land}{color of landmasses in the map}

\item{xytable}{data frame of latitude and longitude values which will be
connected by the arrows representing movement rates. The order should match
the order of areas in \code{polygonlist} and in the SS model. Not necessary
if no arrows are shown on the map.}

\item{moveage}{age for which movemement rates will be represented}

\item{moveseas}{season for which movement rates will be represented}

\item{lwdscale}{scaling factor for arrows in the plot. The largest rate of
movement shown will be scaled to have a line width equal to this value.}

\item{legend}{add a legend to show the movement rate associated with the
widest arrows}

\item{title}{optional title to be added above map}

\item{areanames}{optional vector of names to be shown on map at coordinates
matching xytable values}

\item{cex}{character expansion to apply to text shown by areanames (if used)}
}
\description{
Make a map with colored spatial cells and add arrows representing movement
rates between cells.
}
\note{
Inspired by plots of MULTIFAN-CL movement patterns presented by Adam
Langley
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SS_output}}, \code{\link{SSplotMovementRates}},
\code{\link{IOTCmove}}
}
\keyword{hplot}

