% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_values.R
\name{domain_values}
\alias{domain_values}
\title{Download Domain Values}
\usage{
domain_values(domain_name = NULL, context = NULL, tidy = TRUE, ...)
}
\arguments{
\item{domain_name}{(character) Specified the domain name to obtain valid
parameter values for. Defaults to \code{NULL} which will a tibble with all
the domain names. To return the allowable parameter values for a given
domain, the domain should be specified here. optional}

\item{context}{(character) When specified, the service will return
domain_name values  alongside the context. optional.}

\item{tidy}{(logical) \code{TRUE} (default) the function returns a tidied
tibble. \code{FALSE} the function returns the raw JSON string.}

\item{...}{list of curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
If \code{tidy = FALSE} the raw JSON string is returned, else the JSON
data is parsed and returned as a tibble.
}
\description{
Provides information on allowed parameter values in ATTAINS.
}
\note{
Data downloaded from the EPA webservice is automatically cached to
reduce uneccessary calls to the server. To managed cached files see
\link{rATTAINS_caching}
}
\examples{


\dontrun{

## return a tibble with all domain names
domain_values()

## return allowable parameter values for a given domain name and context
domain_values(domain_name="UseName",context="TCEQMAIN")

## return the query as a JSON string instead
domain_values(domain_name="UseName",context="TCEQMAIN", tidy= FALSE)
}
}
