% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/StockPanel.R
\docType{methods}
\name{initialize,StockPanel-method}
\alias{addStockGraph}
\alias{addStockGraph,StockPanel-method}
\alias{initialize,StockPanel-method}
\alias{setDrawOnAxis}
\alias{setDrawOnAxis,StockPanel-method}
\alias{setStockGraphs}
\alias{setStockGraphs,StockPanel-method}
\alias{setStockLegend}
\alias{setStockLegend,StockPanel-method}
\alias{stockPanel}
\title{Initialize a StockPanel}
\usage{
\S4method{initialize}{StockPanel}(.Object, drawOnAxis, stockGraphs, stockLegend,
  ...)

stockPanel(drawOnAxis, stockGraphs, stockLegend, ...)

setDrawOnAxis(.Object, valueAxis = NULL, ...)

\S4method{setDrawOnAxis}{StockPanel}(.Object, valueAxis = NULL, ...)

setStockGraphs(.Object, stockGraphs)

\S4method{setStockGraphs}{StockPanel}(.Object, stockGraphs)

addStockGraph(.Object, stockGraph = NULL, ...)

\S4method{addStockGraph}{StockPanel}(.Object, stockGraph = NULL, ...)

setStockLegend(.Object, stockLegend = NULL, ...)

\S4method{setStockLegend}{StockPanel}(.Object, stockLegend = NULL, ...)
}
\arguments{
\item{.Object}{\code{\linkS4class{StockPanel}}.}

\item{drawOnAxis}{\code{\linkS4class{ValueAxis}}.
Specifies on which value axis user can draw trend lines.
Set drawingIconsEnabled to true if you want drawing icons to be visible.
First value axis will be used if not set here.
You can use a reference to the value axis object or id of value axis.}

\item{stockGraphs}{\code{list} of \code{\linkS4class{AmGraph}}.
Each element must be have been created with stockGraph(*)}

\item{stockLegend}{\code{list} of \code{\linkS4class{AmLegend}}.
Each element must be have been created with stockLegend(*)}

\item{...}{Other properties...}

\item{valueAxis}{\linkS4class{ValueAxis}}

\item{stockGraph}{\linkS4class{AmGraph}, created with stockGraph(...)}
}
\value{
(updated) \linkS4class{StockPanel} with given properties.
}
\description{
Initialize a StockPanel
}
\section{Functions}{
\itemize{
\item \code{stockPanel}: 
}}
\examples{
new("StockPanel")
stockPanel()
setDrawOnAxis(.Object = stockPanel(), valueAxis = valueAxis())
setDrawOnAxis(.Object = stockPanel(), valueAxis = "valueAxis1")
stockGraphs <- list(stockGraph(comparable = TRUE), stockGraph(comparable = FALSE))
setStockGraphs(.Object =  stockPanel(), stockGraphs = stockGraphs)
stockPanel(stockGraphs = stockGraphs)
addStockGraph(.Object = stockPanel(), comparable = FALSE)
addStockGraph(.Object = stockPanel(), stockGraph = stockGraph(TEST = FALSE))
setStockLegend(.Object = stockPanel(), stockLegend = stockLegend())
}

