% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amGauge.R
\name{amAngularGauge}
\alias{amAngularGauge}
\title{Plotting gauge using rAmCharts}
\usage{
amAngularGauge(x, start = 0, end = 100, step = 20,
  bands = data.frame(start = numeric(), end = numeric(), color = character(),
  width = numeric(), stringsAsFactors = FALSE), text = "", textSize = 25,
  secondAxe = FALSE, start2 = 0, end2 = 100, step2 = 20,
  bands2 = data.frame(start = numeric(), end = numeric(), color = character(),
  stringsAsFactors = FALSE), ...)
}
\arguments{
\item{x}{\code{numeric}, value for which the angular gauge is desired.}

\item{start}{\code{numeric}, minimum value allowed.}

\item{end}{\code{numeric}, maximum value allowed.}

\item{step}{\code{numeric}, intervals size.}

\item{bands}{\code{data.frame} with 4 columns : start (numeric, minimal value for the band), 
end (numeric, maximal value for the band), color (character, color of the band, in hexadecimal)
and width (numeric, width of the band). If the last column is not defined, it is auomatically
set to 10.}

\item{text}{\code{character}, text lengend.}

\item{textSize}{\code{numeric}, text size.}

\item{secondAxe}{\code{logical}, TRUE if two axes are desired. Default is set to FALSE.}

\item{start2}{\code{numeric}, minimum value allowed for the second axe if secondAxe is TRUE.}

\item{end2}{\code{numeric}, maximum value allowed for the second axe if secondAxe is TRUE.}

\item{step2}{\code{numeric}, intervals size for the second axe if secondAxe is TRUE.}

\item{bands2}{\code{data.frame} with 4 columns : start (numeric, minimal value for the band), 
end (numeric, maximal value for the band), color (character, color of the band, in hexadecimal)
and width (numeric, width of the band). If the last column is not defined, it is auomatically
set to 10.}

\item{...}{see \link{amOptions} for more options.}
}
\description{
amAngularGauge computes a gauge of the given value.
}
\seealso{
\itemize{
\item{\url{https://datastorm-open.github.io/introduction_ramcharts/}}
}
}

