% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amFunnel.R
\name{amFunnel}
\alias{amFunnel}
\title{Plotting funnel chart using rAmCharts}
\usage{
amFunnel(data, inverse = FALSE, neck_height = NULL,
  neck_width = NULL, depth = 0, label_side = "right",
  margin_right = 200, margin_left = 200, ...)
}
\arguments{
\item{data}{\code{data.frame} of at least 2 columns : value (numeric, positive), 
and description (character). You can add a third column "color" (character,
colors in hexadecimal) see \link{data_funnel}.}

\item{inverse}{\code{logical}, if TRUE, the funnel chart will be inversed.}

\item{neck_height}{\code{numeric}, value between 0 and 100 : if a bottleneck
is desired, this value determines its heigh. Default to NULL.}

\item{neck_width}{\code{numeric}, value between 0 and 100 : if a bottleneck
is desired, this value determines its witdh. Default to NULL.}

\item{depth}{\code{numeric}, if > 0, chart is displayed in 3D, only for
pyramid chart (without a bottleneck). Value between 0 and 100.}

\item{label_side}{\code{character}, label position : "right" or "left".}

\item{margin_right}{\code{numeric}, margin at the right side.}

\item{margin_left}{\code{numeric}, margin at the left side.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amFunnel computes a funnel chart of the given value.
}
\examples{
data(data_funnel)
amFunnel(data = data_funnel, inverse = TRUE)

\donttest{
# Other examples available which can be time consuming depending on your configuration.

# Change the orientation and legend side              
amFunnel(data = data_funnel, inverse = FALSE,
         label_side = "left", margin_right = 15, margin_left = 160)

# Basic example : Funnel chart
amFunnel(data = data_funnel, neck_height = 30, neck_width = 40)

# 3D pyramid
amFunnel(data = data_funnel, depth = 50, inverse = TRUE)
}



}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
