% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amFloatingBar.R
\name{amFloatingBar}
\alias{amFloatingBar}
\title{Plotting floating bar chart using rAmCharts}
\usage{
amFloatingBar(x, y_inf, y_sup, data, xlab = "", ylab = "",
  groups_color = NULL, horiz = FALSE, show_values = FALSE, depth = 0,
  dataDateFormat = NULL, minPeriod = ifelse(!is.null(dataDateFormat), "DD",
  ""), ...)
}
\arguments{
\item{x}{\code{character}, column name for x-axis or \code{numeric} value of the corresponding column.
It is optional if argument \code{data} has row names.}

\item{y_inf}{\code{character}, column name for the lower value or \code{numeric}  vector
of the corresponding column.}

\item{y_sup}{\code{character}, column name for the upper value or \code{numeric}  vector
of the corresponding column.}

\item{data}{\code{data.frame}, dataframe with values to display.
You can add a column "color" (character, colors in hexadecimal). You can
also add a column "description" (character) containing the text you want to
display when mouse is on the graphic ('<br>' for a new line).
See \link{data_fbar}.}

\item{xlab}{\code{character}, label for x-axis.}

\item{ylab}{\code{character}, label for y-axis.}

\item{groups_color}{\code{character}, vector of colors in hexadecimal, 
same length as y_inf or y_sup.}

\item{horiz}{\code{logical}, TRUE for an horizontal chart, FALSE for a vertical one
If 'horiz' is set to TRUE, the setting 'labelRotation' will be ignored.}

\item{show_values}{\code{logical}, TRUE to display values.}

\item{depth}{\code{numeric}, if > 0, chart is displayed in 3D. Value between 0 and 100.}

\item{dataDateFormat}{\code{character}, default set to NULL. Even if your chart parses dates,
you can pass them as strings in your dataframe - 
all you need to do is to set data date format and the chart will parse dates to date objects.
Check this page for available formats.
Please note that two-digit years (YY) as well as literal month names (MMM)  are NOT supported in this setting.}

\item{minPeriod}{Specifies the shortest period of your data.
This should be set only if dataDateFormat is not 'NULL'.
Possible period values:
fff - milliseconds, ss - seconds, mm - minutes, hh - hours, DD - days, MM - months, YYYY - years.
It's also possible to supply a number for increments, i.e. '15mm'
which will instruct the chart that your data is supplied in 15 minute increments.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\value{
An object of class \linkS4class{AmChart}.
}
\description{
amFloatingBar computes a floating bar chart of the given values.
}
\details{
\strong{Notice about labels:}
if the chart has many columns, several labels might be hidden.
It depends on the width of the conatainer where the chart is displayed.
Zoom on the chart to see if the chart can contain all labels.
You can also add a cursor to your chart...
}
\examples{
# Load data
data(data_fbar)
data(data_gbar)

amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, labelRotation = -45)
              
amFloatingBar(x = "year", y_inf = "expenses", y_sup = "income", data = data_gbar,
              dataDateFormat = "YYYY", minPeriod = "YYYY", zoom = TRUE)
              
\donttest{
# Other examples available which can be time consuming depending on your configuration.
library(pipeR)

# Reference example : column chart
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, labelRotation = -45)

# Label rotation modification
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, labelRotation = -90)

# Horizontal bar
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, horiz = TRUE)

# 3D bar
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, labelRotation = -45, depth = 15)

# Display values
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar, labelRotation = -90, show_values = TRUE)

# Change colors
amFloatingBar(x = "country", y_inf = "visits_inf", y_sup = "visits_sup",
              data = data_fbar[,1:3], labelRotation = -45, groups_color = "#67b7dc")


# Grouped columns
# Parse dates

# Default label: firt day of each year

amFloatingBar(x = "year", y_inf = "expenses", y_sup = "income", data = data_gbar,
              dataDateFormat = "YYYY", minPeriod = "YYYY", zoom = TRUE)

# Default label: first day of each month

amFloatingBar(x = "month", y_inf = "expenses", y_sup = "income", data = data_gbar,
              dataDateFormat = "MM/YYYY", minPeriod = "MM", zoom = TRUE)


amFloatingBar(x = "day", y_inf = "expenses", y_sup = "income", data = data_gbar,
              dataDateFormat = "DD/MM/YYYY", zoom = TRUE)

}


}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
