% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineStyle.R
\name{amLine}
\alias{amLine}
\title{Line style}
\usage{
amLine(
  color = NULL,
  opacity = 1,
  width = 3,
  dash = NULL,
  tensionX = NULL,
  tensionY = NULL
)
}
\arguments{
\item{color}{line color}

\item{opacity}{line opacity, a number between 0 and 1}

\item{width}{line width}

\item{dash}{string defining a dashed/dotted line; see
\href{https://www.amcharts.com/docs/v4/tutorials/dotted-and-dashed-lines/#Dasharray_values}{Dotted and dashed lines}}

\item{tensionX, tensionY}{parameters for the smoothing; see
\href{https://www.amcharts.com/docs/v4/chart-types/xy-chart/#Smoothed_lines}{Smoothed lines}
for the meaning of these parameters}
}
\value{
A list of settings for a line.
}
\description{
Create a list of settings for a line.
}
\note{
A color can be given by the name of a R color, the name of a CSS
  color, e.g. \code{"transparent"} or \code{"fuchsia"}, an HEX code like
  \code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
  like \code{"hsl(360,11,255)"}.
}
