% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_exampleplot.R
\name{create_exampleplot}
\alias{create_exampleplot}
\title{create_exampleplot helper function}
\usage{
create_exampleplot(
  data,
  coef_hyper,
  coef_cubic,
  plot_height,
  plot_width,
  plot_textsize,
  filename
)
}
\arguments{
\item{data}{A data.table containing the aggregated
calibration data.}

\item{coef_hyper}{A list containing the regression parameters of
the hyperbolic regression equation.}

\item{coef_cubic}{A list containing the regression parameters of
the cubic regression equation.}

\item{plot_height}{A integer value. The height (unit: inch) of the
resulting plots (default: 5).}

\item{plot_width}{A integer value. The width (unit: inch) of the
resulting plots (default: 7.5).}

\item{plot_textsize}{A integer value. The textsize of the
resulting plots (default: 16).}

\item{filename}{A character. The filename, where to
store the resulting example plot.}
}
\value{
The function creates an example plot and stores
  on the local filesystem.
}
\description{
Internal function to create an example plot.
}
\examples{
gdat <- rBiasCorrection::example._plot.df_agg

coef_h <- rBiasCorrection::example._plot_coef_h
coef_c <- rBiasCorrection::example._plot_coef_c

create_exampleplot(
  data = gdat,
  coef_hyper = coef_h,
  coef_cubic = coef_c,
  plot_height = 5,
  plot_width = 7.5,
  plot_textsize = 1,
  filename = paste0(tempdir(), "/exampleplot.png")
)

}
