% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IUCNcat.R
\name{EOORating}
\alias{EOORating}
\title{IUCN rating based from EOO Area}
\usage{
EOORating(EOOArea, abb)
}
\arguments{
\item{EOOArea}{Area in km2}

\item{abb}{TRUE or FALSE , TRUE = 2 letter code, FALSE = full text (see value), default = TRUE}
}
\value{
Text
one of CR, EN, VU, NT, LC or Critically Endangered, Endangered, Vulnerable, Near Threatened, Least Concern
}
\description{
Calculates IUCN rating based on Extent of Occurance (EOO) Area in km2
}
\details{
Calculates IUCN rating from EOO
}
\note{
Any negative values are assumpted to be positive. Near Threatened is set at 30,000 km2, follow example in IUCN petition 2014
}
\examples{
EOOArea <- 25 
EOORtext <- EOORating(EOOArea,TRUE)
}
\references{
Bachman, S., Moat, J., Hill, A.W., de Torre, J., Scott, B., 2011. Supporting Red List threat assessments with GeoCAT: geospatial conservation assessment tool. Zookeys 126, 117–26. doi:10.3897/zookeys.150.2109 

Moat, J., Bachman, S., n.d. GeoCAT Geospatial Conservation Assessment Tool [WWW Document]. URL http://geocat.kew.org/

IUCN, 2012. IUCN RED LIST CATEGORIES AND CRITERIA, 2nd ed. IUCN, Gland, Switzerland. 

IUCN Standards and Petitions Subcommittee, 2014. Guidelines for Using the IUCN Red List Categories and Criteria. Version 11.

IUCN Standards and Petitions Subcommittee, 2016. Guidelines for Using the IUCN Red List Categories and Criteria. Version 12.

Joppa, L.N., Butchart, S.H.M., Hoffmann, M., Bachman, S.P., Akçakaya, H.R., Moat, J.F., Böhm, M., Holland, R.A., Newton, A., Polidoro, B., Hughes, A., 2016. Impact of alternative metrics on estimates of extent of occurrence for extinction risk assessment. Conserv. Biol. 30, 362–370. doi:10.1111/cobi.12591
}
\seealso{
\code{\link{EOOarea}} for EOO calculations
}
\author{
Justin Moat. J.Moat@kew.org
}
