% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{cnv}
\alias{cnv}
\title{Find CNVs from deviants}
\usage{
cnv(
  data,
  test = c("z.het", "z.05", "z.all", "chi.het", "chi.05", "chi.all"),
  filter = c("intersection", "kmeans"),
  WGS = TRUE,
  ft.threshold = 0.05,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame of allele information generated with the function
\code{allele.info}}

\item{test}{vector of characters. Type of test to be used for significance.
See details}

\item{filter}{character. Type of filter to be used for filtering CNVs.
default \code{kmeans}. See details.}

\item{WGS}{logical. test parameter. See details
\code{WGS} is a test parameter to include or exclude coefficient of variance
(cv) in kmeans. For data sets with more homogeneous depth distribution,
excluding cv improves CNV detection. If you're not certain about this, use
\code{TRUE} which is the default.}

\item{ft.threshold}{confidence interval for filtering \code{default = 0.05}}

\item{plot}{logical. Plot the detection of duplicates. default \code{TRUE}}

\item{verbose}{logical. show progress}

\item{...}{other arguments to be passed to \code{plot}}
}
\value{
Returns a data frame of SNPs with their detected duplication status
}
\description{
Categorize deviant and non-deviant into "singlets" and "duplicates" based on the statistical approaches specified by the user.
The intersection of all the stats provided will be used in the categorization. If one would like to use the intersection of at least two stats, this can be specified in the \code{n.ints}
}
\details{
SNP deviants are detected with both excess of heterozygosity
according to HWE and deviant SNPs where depth values fall outside of the
normal distribution are detected using the
following methods:
\itemize{
\item{Z-score test \eqn{Z_{x} = \sum_{i=1}^{n} Z_{i}};
\eqn{Z_{i} = \frac{\left ( (N_{i}\times p)- N_{Ai} \right )}{\sqrt{N_{i}\times p(1-p)}}}}
\item{chi-square test \eqn{X_{x}^{2} = \sum_{i-1}^{n} X_{i}^{2}};
\eqn{X_{i}^{2} = (\frac{(N_{i}\times p - N_{Ai})^2}{N_{i}\times p} + \frac{(N_{i}\times (1 - p)- (N_{i} - N_{Ai}))^2}{N_{i}\times (1-p)})}}
}
See references for more details on the methods

Users can pick among Z-score for heterozygotes (\code{z.het, chi.het}),
all allele combinations (\code{z.all, chi.all}) and the assumption of no
probe bias p=0.5 (\code{z.05, chi.05})

\code{filter} will determine whether the \code{intersection} or \code{kmeans}
clustering of the provided \code{test}s should be used in filtering CNVs.
The intersection uses threshold values for filtering and kmeans use
unsupervised clustering. Kmeans clustering is recommended if one is uncertain
about the threshold values.
}
\examples{
\dontrun{data(alleleINF)
DD<-cnv(alleleINF)}

}
\author{
Piyal Karunarathne
}
