% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivewrapper.R
\name{naiveWrapper}
\alias{naiveWrapper}
\title{Naive feature selection method utilising the rFerns shadow imporance}
\usage{
naiveWrapper(x, y, iterations = 1000, depth = 5, ferns = 100, size = 30)
}
\arguments{
\item{x}{Data frame containing attributes; must have unique names and contain only numeric, integer or (ordered) factor columns.
Factors must have less than 31 levels. No \code{NA} values are permitted.}

\item{y}{A decision vector. Must a factor of the same length as \code{nrow(X)} for ordinary many-label classification, or a logical matrix with each column corresponding to a class for multi-label classification.}

\item{iterations}{Number of iterations i.e., the number of sub-models built.}

\item{depth}{The depth of the ferns; must be in 1--16 range. Note that time and memory requirements scale with \code{2^depth}.}

\item{ferns}{Number of ferns to be build in each sub-model. This should be a small number, around 3-5 times \code{size}.}

\item{size}{Number of attributes considered by each sub-model.}
}
\value{
An object of class \code{naiveWrapper}, which is a list with the following components:
\item{found}{Names of all selected attributes.}
\item{weights}{Vector of weights indicating the confidence that certain feature is relevant.}
\item{timeTaken}{Time of computation.}
\item{params}{Copies of algorithm parameters, \code{iterations}, \code{depth}, \code{ferns} and \code{size}, as a named vector.}
}
\description{
Proof-of-concept ensemble of rFerns models, built to stabilise and improve selection based on shadow importance.
It employs a super-ensemble of \code{iterations} small rFerns forests, each built on a subspace of \code{size} attributes, which is selected randomly, but with a higher selection probability for attributes claimed important by previous sub-models.
Final selection is a group of attributes which hold a substantial weight at the end of the procedure.
}
\examples{
set.seed(77);
#Fetch Iris data
data(iris)
#Extend with random noise
noisyIris<-cbind(iris[,-5],apply(iris[,-5],2,sample));
names(noisyIris)[5:8]<-sprintf("Nonsense\%d",1:4)
#Execute selection
naiveWrapper(noisyIris,iris$Species,iterations=50,ferns=20,size=8)
}
\references{
Kursa MB (2017). \emph{Efficient all relevant feature selection with random ferns}. In: Kryszkiewicz M., Appice A., Slezak D., Rybinski H., Skowron A., Ras Z. (eds) Foundations of Intelligent Systems. ISMIS 2017. Lecture Notes in Computer Science, vol 10352. Springer, Cham.
}
\author{
Miron B. Kursa
}
