% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estEllipse.R
\name{estEllipse}
\alias{estEllipse}
\title{Estimate Bivariate Normal Ellipse Isotope Niche}
\usage{
estEllipse(data, x, y, group, levels = c(50, 75, 95), smallSamp = FALSE)
}
\arguments{
\item{data}{data.frame object containing columns of isotopic values and grouping variables}

\item{x}{character giving the column name of the x coordinates}

\item{y}{character giving the column name of the y coordinates}

\item{group}{character giving the column name of the grouping variable (i.e. species)}

\item{levels}{Numeric vector of desired percent levels (e.g. c(10, 50, 90). Should not be less than 1 or greater than 100)}

\item{smallSamp}{logical value indicating whether to override minimum number of samples. Currently 10 samples are required.}
}
\value{
A list of SpatialPolygonsDataFrame, each list item representing the grouping variable.
}
\description{
Calculates the Bivariate Normal Ellipse Polygon for isotopic values at multiple confidence levels. Returns a list of
SpatialPolygonsDataFrame, each list item representing the grouping variable (i.e. species).
}
\examples{
library(rKIN)
data("rodents")
#estimate niche overlap between 2 species using bivariate ellipse
test.elp<- estEllipse(data=rodents, x="Ave_C", y="Ave_N", group="Species",
                     levels=c(50, 75, 95))
#determine polygon overlap for all polygons
plotKIN(test.elp, scaler=2, title="Ellipse Estimates", xlab="Ave_C", ylab="Ave_N")
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}

