% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVolume.R
\name{calcVolume}
\alias{calcVolume}
\title{Calculate Pelagic Habitat Volumes}
\usage{
calcVolume(
  DEM,
  thermo_depth = NULL,
  thermo_high,
  thermo_low,
  DEMunits = "m",
  depthUnits = "ft",
  by = 1,
  stop = NULL
)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{thermo_depth}{number giving the estimated middle of thermocline, results in calculation of only epilimnion and hypolimnion volumes. Default = NULL, cannot use in conjunction with thermo_low and thermo_high}

\item{thermo_high}{number giving the upper bound of thermocline depth, results in calculation of epilimnion, metalimnion, and hypolimnion values}

\item{thermo_low}{number giving the lower bound of thermocline depth, results in calculation of epilimnion, metalimnion, and hypolimnion values}

\item{DEMunits}{character describing units of raster coordinate system. Can be meters, kilometers, or hectares ("m", "km", "ha"), default = "m"}

\item{depthUnits}{character describing units of depth measurement. Can be either feet or meters ("ft", "m"), default = "ft"}

\item{by}{numeric increment per unit by which volumes are calculated. Higher values will result in lower resolution. Default = 1}

\item{stop}{optional numeric value specifying depth at which to stop habitat volume calculations, default = NULL}
}
\value{
a data frame of volumes in cubic meters calculated for each habitat (epilimnion, metalimnion, hypolimnion)
}
\description{
Calculates epilimnion, metalimnion, and hypolimnion volumes based on defined thermocline depths across water levels.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
calcVolume(DEM, thermo_depth = 3, DEMunits = 'm', depthUnits = 'm')
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
