% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.MLM.r
\name{MVP.MLM}
\alias{MVP.MLM}
\title{To perform GWAS with GLM and MLM model and get the P value of SNPs}
\usage{
MVP.MLM(
  phe,
  geno,
  K = NULL,
  eigenK = NULL,
  CV = NULL,
  REML = NULL,
  cpu = 1,
  vc.method = c("BRENT", "EMMA", "HE"),
  verbose = TRUE
)
}
\arguments{
\item{phe}{phenotype, n * 2 matrix}

\item{geno}{genotype, m * n, m is marker size, n is population size}

\item{K}{Kinship, Covariance matrix(n * n) for random effects; must be positive semi-definite}

\item{eigenK}{list of eigen Kinship}

\item{CV}{covariates}

\item{REML}{a list that contains ve and vg}

\item{cpu}{number of cpus used for parallel computation}

\item{vc.method}{the methods for estimating variance component("emma" or "he" or "brent")}

\item{verbose}{whether to print detail.}
}
\value{
results: a m * 2 matrix, the first column is the SNP effect, the second column is the P values
}
\description{
Build date: Aug 30, 2016
Last update: Aug 30, 2016
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
idx <- !is.na(phenotype[, 2])
phenotype <- phenotype[idx, ]
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
genotype <- deepcopy(genotype, cols=idx)
print(dim(genotype))
K <- MVP.K.VanRaden(genotype, cpu=1)

mlm <- MVP.MLM(phe=phenotype, geno=genotype, K=K, cpu=1)
str(mlm)
}

}
\author{
Lilin Yin and Xiaolei Liu
}
