% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt.R
\name{pt.Hz2ST}
\alias{pt.Hz2ST}
\title{pt.Hz2ST}
\usage{
pt.Hz2ST(pt, ref = 100)
}
\arguments{
\item{pt}{PitchTier object}

\item{ref}{reference value (in Hz) for 0 ST. Default: 100 Hz.}
}
\value{
PitchTier object
}
\description{
Converts Hz to Semitones with given reference (default 0 ST = 100 Hz).
}
\examples{
pt <- pt.sample()
pt2 <- pt.Hz2ST(pt, ref = 200)
\dontrun{
pt.plot(pt)  \%>\% dygraphs::dyAxis("y", label = "Frequency (Hz)")
pt.plot(pt2) \%>\% dygraphs::dyAxis("y", label = "Frequency (ST re 200 Hz)")
}
}
\seealso{
\code{\link{pt.read}}, \code{\link{pt.write}}, \code{\link{pt.plot}}, \code{\link{pt.interpolate}}, \code{\link{pt.cut}}, \code{\link{pt.cut0}}
}
