% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{rspde.make.index}
\alias{rspde.make.index}
\title{rSPDE model index vector generation}
\usage{
rspde.make.index(
  name,
  n.spde = NULL,
  n.group = 1,
  n.repl = 1,
  mesh = NULL,
  rspde.order = 2,
  nu = NULL,
  dim = NULL
)
}
\arguments{
\item{name}{A character string with the base name of the effect.}

\item{n.spde}{The number of basis functions in the mesh model.}

\item{n.group}{The size of the group model.}

\item{n.repl}{The total number of replicates.}

\item{mesh}{An \code{inla.mesh},
an \code{inla.mesh.1d} object or a \code{metric_graph} object.}

\item{rspde.order}{The order of the rational approximation}

\item{nu}{If \code{NULL}, then the model will assume that nu will
be estimated. If nu is fixed, you should provide the value of nu.}

\item{dim}{the dimension of the domain. Should only be provided if
\code{mesh} is not provided.}
}
\value{
A list of named index vectors.
\item{name}{Indices into the vector of latent variables}
\item{name.group}{'group' indices}
\item{name.repl}{Indices for replicates}
}
\description{
Generates a list of named index vectors for an rSPDE model.
}
\examples{
\donttest{ #tryCatch version
tryCatch({
if (requireNamespace("INLA", quietly = TRUE)){
library(INLA)

set.seed(123)

m <- 100
loc_2d_mesh <- matrix(runif(m * 2), m, 2)
mesh_2d <- inla.mesh.2d(
  loc = loc_2d_mesh,
  cutoff = 0.05,
  max.edge = c(0.1, 0.5)
)
sigma <- 1
range <- 0.2
nu <- 0.8
kappa <- sqrt(8 * nu) / range
op <- matern.operators(
  mesh = mesh_2d, nu = nu,
  kappa = kappa, sigma = sigma, m = 2
)
u <- simulate(op)
A <- inla.spde.make.A(
  mesh = mesh_2d,
  loc = loc_2d_mesh
)
sigma.e <- 0.1
y <- A \%*\% u + rnorm(m) * sigma.e
Abar <- rspde.make.A(mesh = mesh_2d, loc = loc_2d_mesh)
mesh.index <- rspde.make.index(name = "field", mesh = mesh_2d)
st.dat <- inla.stack(
  data = list(y = as.vector(y)),
  A = Abar,
  effects = mesh.index
)
rspde_model <- rspde.matern(
  mesh = mesh_2d,
  nu.upper.bound = 2
)
f <- y ~ -1 + f(field, model = rspde_model)
rspde_fit <- inla(f,
  data = inla.stack.data(st.dat),
  family = "gaussian",
  control.predictor =
    list(A = inla.stack.A(st.dat))
)
result <- rspde.result(rspde_fit, "field", rspde_model)
summary(result)
}
#stable.tryCatch
}, error = function(e){print("Could not run the example")})
}
}
