/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

public class SVNScheduleKind {
    private int kind;
    private static final int normal = 0;
    private static final int add = 1;
    private static final int delete = 2;
    private static final int replace = 3;
    public static final SVNScheduleKind NORMAL = new SVNScheduleKind(0);
    public static final SVNScheduleKind ADD = new SVNScheduleKind(1);
    public static final SVNScheduleKind DELETE = new SVNScheduleKind(2);
    public static final SVNScheduleKind REPLACE = new SVNScheduleKind(3);

    private SVNScheduleKind(int n) {
        this.kind = n;
    }

    public int toInt() {
        return this.kind;
    }

    public SVNScheduleKind fromInt(int n) {
        switch (n) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 3: {
                return REPLACE;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "normal";
            }
            case 1: {
                return "add";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "replace";
            }
        }
        return "";
    }

    public static SVNScheduleKind fromString(String string) {
        if (NORMAL.toString().equals(string)) {
            return NORMAL;
        }
        if (ADD.toString().equals(string)) {
            return ADD;
        }
        if (DELETE.toString().equals(string)) {
            return DELETE;
        }
        if (REPLACE.toString().equals(string)) {
            return REPLACE;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SVNScheduleKind)) {
            return false;
        }
        return ((SVNScheduleKind)object).kind == this.kind;
    }

    public int hashCode() {
        return new Integer(this.kind).hashCode();
    }
}

