/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestJavaCodeGeneration
extends BaseTest {
    public void testDupVarDefForPinchedState() {
        String string = "grammar T;\na : (| A | B) X Y\n  | (| A | B) X Z\n  ;\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, "TParser", null, false);
        boolean bl2 = true;
        TestJavaCodeGeneration.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testLabeledNotSetsInLexer() {
        String string = "lexer grammar T;\nA : d=~('x'|'y') e='0'..'9'\n  ; \n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, null, "T", false);
        boolean bl2 = true;
        TestJavaCodeGeneration.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testLabeledSetsInLexer() {
        String string = "grammar T;\na : A ;\nA : d=('x'|'y') {System.out.println((char)$d);}\n  ; \n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", false);
        TestJavaCodeGeneration.assertEquals((String)"x\n", (String)string2);
    }

    public void testLabeledRangeInLexer() {
        String string = "grammar T;\na : A;\nA : d='a'..'z' {System.out.println((char)$d);} \n  ; \n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", false);
        TestJavaCodeGeneration.assertEquals((String)"x\n", (String)string2);
    }

    public void testLabeledWildcardInLexer() {
        String string = "grammar T;\na : A;\nA : d=. {System.out.println((char)$d);}\n  ; \n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", false);
        TestJavaCodeGeneration.assertEquals((String)"x\n", (String)string2);
    }

    public void testSynpredWithPlusLoop() {
        String string = "grammar T; \na : (('x'+)=> 'x'+)?;\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, "TParser", "TLexer", false);
        boolean bl2 = true;
        TestJavaCodeGeneration.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testDoubleQuoteEscape() {
        String string = "lexer grammar T; \nA : '\\\\\"';\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, null, "TLexer", false);
        boolean bl2 = true;
        TestJavaCodeGeneration.assertEquals((boolean)bl2, (boolean)bl);
    }
}

