% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions.R
\name{wind.mean}
\alias{wind.mean}
\title{Wind-data mean}
\usage{
wind.mean(wind_series)
}
\arguments{
\item{wind_series}{A list of data.frames downloaded by wind.dl function.}
}
\value{
A data.frame with a similar format as resulted by wind.dl, prepared
to be transformed by wind.fit.
}
\description{
wind.mean computes the mean (average) of a time series dataset of winds in
the same region. To do this, wind.mean uses U and V vector components of
several wind data.frames stored in a list. Note that, if you want to perform
wind direction and speed average, first you should calculate the mean of U
and V components and then transform it to direction and speed using wind.fit
function from "rWind" package.
}
\note{
For large time series, it could take a while.
}
\examples{

# First, you should create an empty list to store all the data

# wind_series<- list()

# Then, you can use a wind.dl inside a for-in loop to download and store wind data of
# the January 3rd 2015 at several hours around New Zealand.

# t<-c(00 , 03 , 06 , 09 , 12 , 15 , 18 , 21)
# for (tt in 1:8){
#  w<-wind.dl(2015,1,3,t[tt],164,179,-48,-33)
#  wind_series[[tt]]<-w
# }

data(wind_series)

# Finally, you can implement wind.mean and wind.fit to compute the average of all winds
# datasets in the list:

wind_average<- wind.mean(wind_series)

# wind.fit(wind_average)


}
\references{
https://en.wikipedia.org/wiki/Cross_product
}
\seealso{
\code{\link{wind.dl}}, \code{\link{wind.fit}}
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\keyword{~kwd1}
\keyword{~kwd2}
