% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rWind-package.R
\docType{data}
\name{wind.series}
\alias{wind.series}
\title{Wind series example}
\format{The format is an rWind list of 8 data.frame. Each data.frame contain
961 observations on the following 7 variables:

\describe{ \item{list("time (UTC)")}{a factor with selected time of wind
data } \item{list("latitude (degrees_north)")}{a factor with latitude values
} \item{list("longitude (degrees_east)")}{a factor with longitude values }
\item{list("ugrd10m (m s-1)")}{a factor with U component of wind data }
\item{list("vgrd10m (m s-1)")}{a factor with V component of wind data }
\item{list("dir")}{a numeric with direction of wind data }
\item{list("speed")}{a numeric with speed of wind data } }}
\source{
http://allthiswasfield.blogspot.com.es/2016/12/rwind-r-package-released.html
}
\description{
This is an example of a wind series data obtained with wind.dl function
for New Zealand area on 3/January/2015 at all the available times:
00:00 - 03:00 - 06:00 - 09:00 - 12:00 - 15:00 - 18:00 - 21:00 (UTC)
}
\details{
This data set is the result of:

\code{library(lubridate)}
\code{dt <- seq(ymd_h(paste(2015,1,3,00, sep="-")),}
\code{          ymd_h(paste(2015,1,3,21, sep="-")),by="3 hours")}
\code{wind.series <- wind.dl_2(dt, 164, 179, -48, -33)}
}
\examples{

data(wind.series)
str(tidy(wind.series))


}
\references{
http://oos.soest.hawaii.edu/erddap/info/NCEP_Global_Best/index.html
}
\keyword{datasets}
