% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tabs.R
\name{summary.cross_tabs}
\alias{summary.cross_tabs}
\title{Summary method for the cross_tabs function}
\usage{
\method{summary}{cross_tabs}(object, check = "", dec = 2, ...)
}
\arguments{
\item{object}{Return value from \code{\link{cross_tabs}}}

\item{check}{Show table(s) for variables var1 and var2. "observed" for the observed frequencies table, "expected" for the expected frequencies table (i.e., frequencies that would be expected if the null hypothesis holds), "chi_sq" for the contribution to the overall chi-squared statistic for each cell (i.e., (o - e)^2 / e), "dev_std" for the standardized differences between the observed and expected frequencies (i.e., (o - e) / sqrt(e)), and "dev_perc" for the percentage difference between the observed and expected frequencies (i.e., (o - e) / e)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Summary method for the cross_tabs function
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/cross_tabs.html} for an example in Radiant
}
\examples{
result <- cross_tabs("newspaper", "Income", "Newspaper")
summary(result, check = c("observed","expected","chi_sq"))
newspaper \%>\% cross_tabs("Income", "Newspaper") \%>\% summary("observed")

}
\seealso{
\code{\link{cross_tabs}} to calculate results

\code{\link{plot.cross_tabs}} to plot results
}
