% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{var_check}
\alias{var_check}
\title{Check if main effects for all interaction effects are included in the model}
\usage{
var_check(ev, cn, intv = c())
}
\arguments{
\item{ev}{List of explanatory variables provided to \code{\link{regress}} or \code{\link{logistic}}}

\item{cn}{Column names for all explanatory variables in the dataset}

\item{intv}{Interaction terms specified}
}
\value{
\code{vars} is a vector of right-hand side variables, possibly with interactions, \code{iv} is the list of explanatory variables, and \code{intv} are interaction terms
}
\description{
Check if main effects for all interaction effects are included in the model
}
\details{
If ':' is used to select a range evar is updated. See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
var_check("a:d", c("a","b","c","d"))
var_check(c("a", "b"), c("a", "b"), "a:c")
var_check(c("a", "b"), c("a", "b"), "a:c")
var_check(c("a", "b"), c("a", "b"), c("a:c", "I(b^2)"))

}
