% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/conjoint.R
\name{plot.conjoint}
\alias{plot.conjoint}
\title{Plot method for the conjoint function}
\usage{
\method{plot}{conjoint}(x, ca_plots = "pw", ca_scale_plot = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{conjoint}}}

\item{ca_plots}{Show either the part-worth ("pw") or importance-weights ("iw") plot}

\item{ca_scale_plot}{Scale the axes of the part-worth plots to the same range}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the conjoint function
}
\details{
See \url{http://vnijs.github.io/radiant/marketing/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint(dataset = "mp3", ca_dep_var = "Rating", ca_indep_var = "Memory:Shape")
plot(result, ca_scale_plot = TRUE)
plot(result, ca_plots = "iw")
}
\seealso{
\code{\link{conjoint}} to generate results

\code{\link{summary.conjoint}} to summarize results
}

