% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myplclust.R
\name{myplclust}
\alias{myplclust}
\title{plclust in colour}
\usage{
myplclust(
  hclust,
  labels = hclust$labels,
  lab.col = rep(1, length(hclust$labels)),
  hang = 0.1,
  xlab = "",
  sub = "",
  ...
)
}
\arguments{
\item{hclust}{hclust object}

\item{labels}{a character vector of labels of the leaves of the tree}

\item{lab.col}{colour for the labels; NA=default device foreground colour}

\item{hang}{as in \code{\link{hclust}} & \code{\link{plclust}}}

\item{xlab}{title for x-axis (defaults to no title)}

\item{sub}{subtitle (defualts to no subtitle)}

\item{...}{further arguments passed to \code{\link{plot}}}
}
\description{
Modifiction of plclust for plotting hclust objects in *in colour*!
}
\examples{
data(iris)
hc <- hclust( dist(iris[,1:4]) )
myplclust(hc, labels=iris$Species,lab.col=as.numeric(iris$Species))


}
\author{
Eva KF Chan
}
