% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clusters_by_doc_table}
\alias{clusters_by_doc_table}
\title{Returns the number of segment of each cluster for each source document}
\usage{
clusters_by_doc_table(obj, clust_var = NULL, doc_id = NULL, prop = FALSE)
}
\arguments{
\item{obj}{a corpus, tokens or dtm object}

\item{clust_var}{name of the docvar with the clusters}

\item{doc_id}{docvar identifying the source document}

\item{prop}{if TRUE, returns the percentage of each cluster by document}
}
\description{
Returns the number of segment of each cluster for each source document
}
\details{
This function is only useful for previously segmented corpus. If \code{doc_id}
is NULL and there is a \code{sement_source} docvar, it will be used instead.
}
\examples{
\donttest{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 2)
res <- rainette(dtm, k = 3, min_segment_size = 15)
corpus$cluster <- cutree(res, k = 3)
clusters_by_doc_table(corpus, clust_var = "cluster", prop = TRUE)
}
}
\seealso{
\code{\link[=docs_by_cluster_table]{docs_by_cluster_table()}}
}
