% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rAtte_fun.R
\name{sumData}
\alias{sumData}
\title{ramchoice Package: Generate Summary Statistics}
\usage{
sumData(menu, choice)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of choice problems.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}
}
\value{
\item{sumMenu}{Summary of choice problems, with repetitions collapsed.}
\item{sumProb}{Estimated choice rules as sample averages for different choice problems.}
\item{sumN}{Effective sample size for each menu.}
\item{sumMsize}{Size of each choice problem.}
\item{sumProbVec}{Estimated choice rule as sample averages, collapsed into a column vector.}
\item{Sigma}{Estimated variance-covariance matrix for the choice rule, scaled by relative sample sizes.}
}
\description{
\code{sumData} generates summary statistics. Given a collection of
  choice problems and corresponding choices, \code{sumData} calculates the
  number of occurrences of each choice problem, as well as the estimated choice
  rule.

This function is embedded in \code{\link{rAtte}}.
}
\examples{
# Load data
data(ramdata)

# Generate summary statistics
summaryStats <- sumData(ramdata$menu, ramdata$choice)
nrow(summaryStats$sumMenu)
min(summaryStats$sumN)

summaryStats$sumMenu[1, ]
summaryStats$sumProb[1, ]
summaryStats$sumN[1]

}
\references{
M. D. Cattaneo, X. Ma, Y. Masatlioglu and E. Suleymanov (2019). \href{http://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy}, forthcoming.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
