% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliaryFunctions.R
\name{sumData}
\alias{sumData}
\title{Generate Summary Statistics}
\usage{
sumData(menu, choice)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of choice problems.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}
}
\value{
\item{sumMenu}{Summary of choice problems, with repetitions removed.}
\item{sumProb}{Estimated choice probabilities as sample averages for different choice problems.}
\item{sumN}{Effective sample size for each choice problem.}
\item{sumMsize}{Size of each choice problem.}
\item{sumProbVec}{Estimated choice probabilities as sample averages, collapsed into a column vector.}
\item{Sigma}{Estimated variance-covariance matrix for the choice rule, scaled by relative sample sizes.}
}
\description{
\code{sumData} generates summary statistics. Given a collection of
  choice problems and corresponding choices, \code{sumData} calculates the
  number of occurrences of each choice problem, as well as the empirical choice
  probabilities.

This function is embedded in \code{\link{revealPref}}.
}
\examples{
# Load data
data(ramdata)

# Generate summary statistics
summaryStats <- sumData(ramdata$menu, ramdata$choice)
nrow(summaryStats$sumMenu)
min(summaryStats$sumN)

summaryStats$sumMenu[1, ]
summaryStats$sumProb[1, ]
summaryStats$sumN[1]

}
\references{
M. D. Cattaneo, P. Cheung, X. Ma, and Y. Masatlioglu (2021). \href{https://arxiv.org/abs/2110.10650}{Attention Overload}. Working paper.

M. D. Cattaneo, X. Ma, Y. Masatlioglu, and E. Suleymanov (2020). \href{https://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy} 128(7): 2796-2836. \doi{10.1086/706861}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Paul Cheung, University of Maryland. \email{hycheung@umd.edu}

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
