% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bsdSeq.R, R/crSeq.R, R/ebcSeq.R, R/hadaSeq.R, R/mpSeq.R, R/pbrSeq.R, R/randSeq.R, R/rarSeq.R, R/tbdSeq.R, R/udSeq.R
\docType{methods}
\name{getProb,bsdSeq-method}
\alias{calcProb}
\alias{calculateProbabilities}
\alias{getProb}
\alias{getProb,bsdSeq-method}
\alias{getProb,crSeq-method}
\alias{getProb,ebcSeq-method}
\alias{getProb,hadaSeq-method}
\alias{getProb,mpSeq-method}
\alias{getProb,pbrSeq-method}
\alias{getProb,rarSeq-method}
\alias{getProb,tbdSeq-method}
\alias{getProb,udSeq-method}
\alias{getProbabilities}
\title{Theoretical probability for randomization sequences}
\usage{
\S4method{getProb}{bsdSeq}(obj)

\S4method{getProb}{crSeq}(obj)

\S4method{getProb}{ebcSeq}(obj)

\S4method{getProb}{hadaSeq}(obj)

\S4method{getProb}{mpSeq}(obj)

\S4method{getProb}{pbrSeq}(obj)

getProb(obj)

\S4method{getProb}{rarSeq}(obj)

\S4method{getProb}{tbdSeq}(obj)

\S4method{getProb}{udSeq}(obj)
}
\arguments{
\item{obj}{object of a class inheriting from randSeq. Formal representation
of a randomization sequences together with the parameters that belong to
the procedure that generated the sequences.}
}
\description{
Calculate theoretical probability for observed randomization sequences
}
\examples{
myPar <- bsdPar(10, 2)
M <- genSeq(myPar, 2)
getProb(M)

# All Sequences
par <- pbrPar(bc=c(2,2))
refSet <- getAllSeq(myPar)
probs <- getProb(refSet)

# Sequences with probabilities
cbind(probs, refSet$M)
}

