% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/udPar.R
\name{udPar}
\alias{udPar}
\title{Representing Wei's Urn Design}
\usage{
udPar(N, ini, add, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{ini}{integer representing the initial urn composition.}

\item{add}{integer representing the number of balls that are added to the
urn in each step.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{udPar}.
}
\description{
Represents Wei's Urn Design.
}
\details{
An urn is filled with a number of \code{ini} balls of both of the treatments.
Afterwards, a ball is drawn randomly from the urn. Finally, \code{add} balls
are added to the urn from the opposite treatment. This procedure is repeated until
\code{N} patients are assigend.
}
\references{
L.J. Wei (1977) A Class of Designs for Sequential Clinical Trials.
\emph{Journal of the American Statistical Association}, \strong{72}, 382-6.
}
\seealso{
Other randomization procedures: \code{\link{bsdPar}};
  \code{\link{crPar}}; \code{\link{createParam}};
  \code{\link{ebcPar}}; \code{\link{hadaPar}};
  \code{\link{mpPar}}; \code{\link{pbrPar}};
  \code{\link{rarPar}}; \code{\link{rpbrPar}};
  \code{\link{rtbdPar}}; \code{\link{tbdPar}}
}

