% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterByProximity.R
\name{filterByProximity}
\alias{filterByProximity}
\title{Filter by proximity}
\usage{
filterByProximity(xy, dist, mapUnits = FALSE, returnIndex = FALSE)
}
\arguments{
\item{xy}{longitude and latitude in decimal degrees, either as class
matrix, SpatialPoints or SpatialPointsDataFrame.}

\item{dist}{minimum allowed distance}

\item{mapUnits}{if \code{TRUE}, distance is interpreted in map units,
distance in kilometers if \code{FALSE}}

\item{returnIndex}{if \code{TRUE}, will return indices of points that would
be dropped, if \code{FALSE}, returns the points that satisfy the distance
filter.}
}
\value{
If \code{returnIndex = TRUE}, returns a numeric vector of indices.
If \code{returnIndex = FALSE}, returns coordinates of the same class as the
input.
}
\description{
Filter occurrence records by their proximity to each other.
}
\details{
This function will discard coordinates that fall within a certain distance
from other points.
}
\examples{

data(crotalus)

# within the first 100 points in the dataset, identify the set of points to 
# drop in order to have points no closer to each other than 20 km

subset <- crotalus[1:100,]
tooClose <- filterByProximity(xy= subset[ ,c('decimallongitude','decimallatitude')], 
	dist=20, mapUnits = FALSE, returnIndex = TRUE)

plot(subset[ ,c('decimallongitude','decimallatitude')], pch=1, col='blue', cex=1.5)
points(subset[tooClose, c('decimallongitude','decimallatitude')], pch=20, col='red')

}
\author{
Pascal Title
}
