% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helpers.R
\name{north_arrow}
\alias{north_arrow}
\title{Helper to add north arrow to map plots}
\usage{
north_arrow(position = "topright", xlim = NULL, ylim = NULL)
}
\arguments{
\item{position}{(character or numeric) position of the North arrow. If
character, options are: "topright", "topleft", "bottomleft", or "bottomright".
Default = "topright".}

\item{xlim}{(numeric) vector of two numbers indicating the x limits of the
plotting area. Default = \code{NULL}.}

\item{ylim}{(numeric) vector of two numbers indicating the y limits of the
plotting area. Default = \code{NULL}.}
}
\value{
Plot of a simple North arrow located in the \code{position} of the plot
specified.
}
\description{
north_arrow plots a North arrow in user defined places in a map.
}
\examples{
# simple plot
plot(1:10, 1:10, col = "transparent")

# north arrows
north_arrow(position = "topright")
north_arrow(position = "bottomright")
}
