% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rap.R
\name{rap}
\alias{rap}
\title{Generate prioritizations using RAP}
\usage{
rap(
  pus,
  species,
  spaces = NULL,
  formulation = c("unreliable", "reliable")[1],
  solve = TRUE,
  ...
)
}
\arguments{
\item{pus}{\code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} object representing planning
units.}

\item{species}{\code{\link[raster:raster]{raster::raster()}} object with species distribution
data.}

\item{spaces}{\code{list} of \code{\link[raster:raster]{raster::raster()}} objects. Each
elements denotes the spatial distribution for each space. Defaults to
\code{NULL}.}

\item{formulation}{\code{character} to indicate if the \code{"unreliable"} or
\code{"reliable"} formulation should be used to generate prioritizations.
Defaults to \code{"unreliable"}.}

\item{solve}{\code{logical} should solutions be generated?}

\item{...}{arguments are passed to \code{\link[=GurobiOpts]{GurobiOpts()}},
\code{\link[=make.RapData]{make.RapData()}}, and \code{\link[=RapReliableOpts]{RapReliableOpts()}} or
\code{\link[=RapUnreliableOpts]{RapUnreliableOpts()}} functions.}
}
\value{
\code{\link[=RapSolved]{RapSolved()}} object if \code{solve} is \code{TRUE},
otherwise an \code{\link[=RapUnsolved]{RapUnsolved()}} is returned.
}
\description{
This is a general function to create Rap objects from scratch and solve them
to generate solutions.
}
\note{
Type \code{vignette("raptr")} to see the package vignette for a
tutorial.
}
\seealso{
\code{\link[=GurobiOpts]{GurobiOpts()}}, \code{\link[=RapReliableOpts]{RapReliableOpts()}},
\code{\link[=RapUnreliableOpts]{RapUnreliableOpts()}} \code{\link[=RapData]{RapData()}},
\code{\link[=RapResults]{RapResults()}}, \code{\link[=RapUnsolved]{RapUnsolved()}},
\code{\link[=RapSolved]{RapSolved()}}.
}
