% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rba-functions.R
\name{rba_file_download}
\alias{rba_file_download}
\title{Function to download statistics files from the RBA website and store locally}
\usage{
rba_file_download(data_url, exdir = tempdir(), update_cache = TRUE)
}
\arguments{
\item{data_url}{Character vector specifying an RBA data set URL.}

\item{exdir}{Target directory for downloaded files (defaults to \code{tempdir()}). Directory is
created if it doesn't exist.}

\item{update_cache}{Logical expression, if FALSE (default), use the cached list of available
RBA datasets, if TRUE, update the list of available datasets.}
}
\value{
Downloads data from the ABS website and returns a character vector listing the location
  where files are saved.
}
\description{
This function downloads one or more RBA data files at the specified by URLs and
  saves a local copy.
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
