% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-epoch.R
\name{RAVEEpoch}
\alias{RAVEEpoch}
\title{Definition for epoch class}
\description{
Trial epoch, contains the following information: \code{Block}
experiment block/session string; \code{Time} trial onset within that block;
\code{Trial} trial number; \code{Condition} trial condition. Other optional
columns are \code{Event_xxx} (starts with "Event"). See
\url{https://openwetware.org/wiki/RAVE:Epoching} or more details.
}
\examples{

# Please download DemoSubject ~700MB from
# https://github.com/beauchamplab/rave/releases/tag/v0.1.9-beta

\dontrun{

# Load meta/epoch_auditory_onset.csv from subject demo/DemoSubject
epoch <-RAVEEpoch$new(subject = 'demo/DemoSubject',
                      name = 'auditory_onset')

# first several trials
head(epoch$table)

# query specific trial
old_trial1 <- epoch$trial_at(1)

# Create new trial or change existing trial
epoch$set_trial(Block = '008', Time = 10,
                Trial = 1, Condition = 'AknownVmeant')
new_trial1 <- epoch$trial_at(1)

# Compare new and old trial 1
rbind(old_trial1, new_trial1)

# To get updated trial table, must update first
epoch$update_table()
head(epoch$table)

}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{epoch name, character}

\item{\code{subject}}{\code{RAVESubject} instance}

\item{\code{data}}{a list of trial information, internally used}

\item{\code{table}}{trial epoch table}

\item{\code{.columns}}{epoch column names, internally used}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{columns}}{columns of trial table}

\item{\code{n_trials}}{total number of trials}

\item{\code{trials}}{trial numbers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RAVEEpoch$new()}}
\item \href{#method-trial_at}{\code{RAVEEpoch$trial_at()}}
\item \href{#method-update_table}{\code{RAVEEpoch$update_table()}}
\item \href{#method-set_trial}{\code{RAVEEpoch$set_trial()}}
\item \href{#method-clone}{\code{RAVEEpoch$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEEpoch$new(subject, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{\code{RAVESubject} instance or character}

\item{\code{name}}{character, make sure \code{"epoch_<name>.csv"} is in meta
folder}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trial_at"></a>}}
\if{latex}{\out{\hypertarget{method-trial_at}{}}}
\subsection{Method \code{trial_at()}}{
get \code{ith} trial
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEEpoch$trial_at(i, df = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{trial number}

\item{\code{df}}{whether to return as data frame or a list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_table"></a>}}
\if{latex}{\out{\hypertarget{method-update_table}{}}}
\subsection{Method \code{update_table()}}{
manually update table field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEEpoch$update_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self$table}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_trial"></a>}}
\if{latex}{\out{\hypertarget{method-set_trial}{}}}
\subsection{Method \code{set_trial()}}{
set one trial
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEEpoch$set_trial(Block, Time, Trial, Condition, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Block}}{block string}

\item{\code{Time}}{time in second}

\item{\code{Trial}}{positive integer, trial number}

\item{\code{Condition}}{character, trial condition}

\item{\code{...}}{other key-value pairs corresponding to other optional columns}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEEpoch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
