% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-metasubject.R
\name{RAVEMetaSubject}
\alias{RAVEMetaSubject}
\title{Defines 'RAVE' subject class for meta analyses}
\value{
data frame
}
\description{
\code{R6} class definition
}
\seealso{
\code{\link{load_meta2}}
}
\section{Super class}{
\code{\link[raveio:RAVESubject]{raveio::RAVESubject}} -> \code{RAVEMetaSubject}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{project}}{project instance of current subject; see
\code{\link{RAVEProject}}}

\item{\code{project_name}}{character string of project name}

\item{\code{subject_code}}{character string of subject code}

\item{\code{subject_id}}{subject ID: \code{"project/subject"}}

\item{\code{path}}{subject root path}

\item{\code{rave_path}}{'rave' directory under subject root path}

\item{\code{meta_path}}{meta data directory for current subject}

\item{\code{freesurfer_path}}{'FreeSurfer' directory for current subject. If
no path exists, values will be \code{NA}}

\item{\code{preprocess_path}}{preprocess directory under subject 'rave' path}

\item{\code{data_path}}{data directory under subject 'rave' path}

\item{\code{cache_path}}{path to 'FST' copies under subject 'data' path}

\item{\code{pipeline_path}}{path to pipeline scripts under subject's folder}

\item{\code{note_path}}{path that stores 'RAVE' related subject notes}

\item{\code{epoch_names}}{possible epoch names}

\item{\code{reference_names}}{possible reference names}

\item{\code{reference_path}}{reference path under 'rave' folder}

\item{\code{preprocess_settings}}{preprocess instance; see
\code{\link{RAVEPreprocessSettings}}}

\item{\code{blocks}}{subject experiment blocks in current project}

\item{\code{electrodes}}{all electrodes, no matter excluded or not}

\item{\code{raw_sample_rates}}{voltage sample rate}

\item{\code{power_sample_rate}}{power spectrum sample rate}

\item{\code{has_wavelet}}{whether electrodes have wavelet transforms}

\item{\code{notch_filtered}}{whether electrodes are Notch-filtered}

\item{\code{electrode_types}}{electrode signal types}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVEMetaSubject-print}{\code{RAVEMetaSubject$print()}}
\item \href{#method-RAVEMetaSubject-new}{\code{RAVEMetaSubject$new()}}
\item \href{#method-RAVEMetaSubject-meta_data}{\code{RAVEMetaSubject$meta_data()}}
\item \href{#method-RAVEMetaSubject-clone}{\code{RAVEMetaSubject$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_default"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_default'><code>raveio::RAVESubject$get_default()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_electrode_table"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_electrode_table'><code>raveio::RAVESubject$get_electrode_table()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_epoch"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_epoch'><code>raveio::RAVESubject$get_epoch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_frequency"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_frequency'><code>raveio::RAVESubject$get_frequency()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_note_summary"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_note_summary'><code>raveio::RAVESubject$get_note_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="get_reference"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-get_reference'><code>raveio::RAVESubject$get_reference()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="initialize_paths"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-initialize_paths'><code>raveio::RAVESubject$initialize_paths()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="set_default"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-set_default'><code>raveio::RAVESubject$set_default()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVESubject" data-id="valid_electrodes"><a href='../../raveio/html/RAVESubject.html#method-RAVESubject-valid_electrodes'><code>raveio::RAVESubject$valid_electrodes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEMetaSubject-print"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEMetaSubject-print}{}}}
\subsection{Method \code{print()}}{
override print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEMetaSubject$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEMetaSubject-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEMetaSubject-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEMetaSubject$new(project_name, subject_code = NULL, strict = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project_name}}{character project name}

\item{\code{subject_code}}{character subject code}

\item{\code{strict}}{whether to check if subject folders exist}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEMetaSubject-meta_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEMetaSubject-meta_data}{}}}
\subsection{Method \code{meta_data()}}{
get subject meta data located in \code{"meta/"} folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEMetaSubject$meta_data(
  meta_type = c("electrodes", "frequencies", "time_points", "epoch", "references"),
  meta_name = "default"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meta_type}}{choices are 'electrodes', 'frequencies', 'time_points',
'epoch', 'references'}

\item{\code{meta_name}}{if \code{meta_type='epoch'}, read in
\code{'epoch_<meta_name>.csv'}; if \code{meta_type='references'},
read in \code{'reference_<meta_name>.csv'}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEMetaSubject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEMetaSubject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEMetaSubject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
