% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_bevel.R
\name{generate_bevel}
\alias{generate_bevel}
\title{Generate 2D Bevel Profile for 3D Polygons}
\usage{
generate_bevel(
  bevel_type = "angled",
  bevel_start = 0,
  bevel_end = 0.2,
  max_height = 1,
  angle = NULL,
  curve_points = 50,
  reverse = FALSE,
  flip = FALSE,
  initial_height = 0,
  add_end_points = TRUE,
  manual_offsets = NULL,
  step_epsilon = 1e-08,
  plot_bevel = FALSE,
  set_minimum_zero = TRUE,
  zero_offset_epsilon = 1e-05
)
}
\arguments{
\item{bevel_type}{Character `angled`. Type of the bevel, one of the following options:
- "circular": Creates a rounded bevel resembling a quarter-circle.
- "exp": Creates an exponential curve, starting slow and accelerating.
- "bump": Creates a bump-like profile, rising and falling within the coverage.
- "step": Generates a step-like bevel with a flat top.
- "block": Generates a block-like bevel, jumping straight to the max_height and back to the base.
- "angled": Generates a straight angled bevel. You can optionally set the 'angle' parameter for this bevel.
- "flat": Generates a flat area.}

\item{bevel_start}{Default `0`. The starting point of the bevel along the curve, ranges between 0 and 1.}

\item{bevel_end}{Default `0.2`. The ending point of the bevel along the curve, ranges between 0 and 1.}

\item{max_height}{Default `1`. The maximum height of the bevel, as measured from the initial height.}

\item{angle}{Default `NULL`. Optional angle parameter in degrees for angular bevels.}

\item{curve_points}{Default `50`. Number of points to plot for curve-based bevels.}

\item{reverse}{Default `FALSE`. If `TRUE`, the curve is reversed vertically.}

\item{flip}{Default `FALSE`. If `TRUE`, the curve is flipped horizontally.}

\item{initial_height}{Default `0`. The initial height from which the bevel starts. The bevel is rescaled to fit within the range from initial_height to max_height.}

\item{add_end_points}{Default `TRUE`. Whether to ensure there is a point at zero and a point at one.}

\item{manual_offsets}{Default `NULL`, none. This will force the bevel to add a point (interpolating between the two nearest points)
at the specified offsets. This is useful when you want to add points at specific distances along the curve.}

\item{step_epsilon}{Default `1e-5`. The size for the small percentage step when using a step bevel.}

\item{plot_bevel}{Default `FALSE`. Whether to plot the bevel.}

\item{set_minimum_zero}{Default `TRUE`. Whether to offset the lowest point of the bevel so it's at zero.}

\item{zero_offset_epsilon}{Default `1e-5`. Amount to offset the bevel to ensure no self-intersection with the base.}
}
\value{
List containing 'x' and 'y', which are the coordinates of the 2D bevel profile.
}
\description{
Generate 2D Bevel Profile for 3D Polygons
}
\examples{
# Generate a single bevel profile and plot it
coords = generate_bevel("circular", 0.2, 0.8, 0.2, plot_bevel = TRUE)

# Plot all bevel profiles in a grid
plot_all_bevels = function() {
  oldpar = par(mfrow = c(4, 3), mai = c(0.2, 0.2, 0.5, 0.2))
  on.exit(par(oldpar))
  max_height = c(1,1,1,1)
  types = rep(c("circular", "exp", "bump", "step", "block", "angled"),2)
  reverses = c(rep(FALSE,6),rep(TRUE,6))
  for(i in seq_len(length(types))) {
    coords = generate_bevel(types[i], 0.2, 0.8, 1, flip = TRUE,
                            angle = 45, reverse = reverses[i], plot_bevel = TRUE)
  }
}
plot_all_bevels()
}
