% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_full_scene.R
\name{generate_full_scene}
\alias{generate_full_scene}
\title{Build  Scene (bonds + atoms)}
\usage{
generate_full_scene(
  model,
  x = 0,
  y = 0,
  z = 0,
  scale = 1,
  center = TRUE,
  pathtrace = TRUE,
  force_single_bonds = FALSE,
  material = rayrender::glossy,
  material_vertex = material_list(type = "phong")
)
}
\arguments{
\item{model}{Model extracted from a PDB or SDF file.}

\item{x}{Default `0`. X offset, applied after centering.}

\item{y}{Default `0`. Y offset, applied after centering.}

\item{z}{Default `0`. Z offset, applied after centering.}

\item{scale}{Default `1`. Amount to scale the interatom spacing.}

\item{center}{Default `TRUE`. Centers the bounding box of the model.}

\item{pathtrace}{Default `TRUE`. If `FALSE`, the `rayvertex` package will be used to render the scene.}

\item{force_single_bonds}{Default `FALSE`. Whether to force all bonds to show as a single connection.}

\item{material}{Default `rayrender::glossy`. Rayrender material to use when `pathtrace = TRUE`. Must be either `glossy`, `diffuse`, or `dielectric`.}

\item{material_vertex}{Default `rayvertex::material_list()`. Material to use when `pathtrace = FALSE`.
`diffuse`/`ambient` colors and `ambient_intensity` are determined automatically, but all other material
properties can be changed.}
}
\value{
Rayrender/rayvertex scene
}
\description{
Reads an SDF file and extracts the 3D molecule model
}
\examples{
# Generate a scene with caffeine molecule
\donttest{
get_example_molecule("caffeine") \%>\%
  read_sdf() \%>\%
  generate_full_scene() \%>\%
  render_model(samples=256,sample_method="sobol_blue")

#Generate a rayvertex scene with a custom material
get_example_molecule("caffeine") \%>\%
  read_sdf() \%>\%
  generate_full_scene(pathtrace=FALSE, material_vertex=rayvertex::material_list(type="phong")) \%>\%
  render_model(background="grey33")

#Generate a rayvertex scene, using toon shading
shiny_toon_material = rayvertex::material_list(type="toon_phong",
                                               toon_levels=3,
                                               toon_outline_width=0.1)
get_example_molecule("caffeine") \%>\%
  read_sdf() \%>\%
  generate_full_scene(pathtrace=FALSE, material_vertex=shiny_toon_material) \%>\%
  render_model(background="grey66")

# Generate a scene with morphine, increasing the inter-atom spacing
get_example_molecule("tubocurarine_chloride") \%>\%
  read_sdf() \%>\%
  generate_full_scene(scale=1.5) \%>\%
  render_model(samples=256,sample_method="sobol_blue")


# Force bonds to appear as a single link (to focus purely on the shape of the molecule)
get_example_molecule("tubocurarine_chloride") \%>\%
  read_sdf() \%>\%
  generate_full_scene(force_single_bonds = TRUE) \%>\%
  render_model(samples=256,sample_method="sobol_blue")

}
}
