% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray.R
\name{ray}
\alias{ray}
\title{Calculates the Rossby waves ray paths}
\usage{
ray(
  betam,
  u,
  lat,
  x0,
  y0,
  K,
  dt,
  itime,
  direction,
  interpolation = "trin",
  tl = 1,
  a = 6371000,
  verbose = FALSE,
  ofile
)
}
\arguments{
\item{betam}{matrix (longitude = rows x latitude from minor to
major = columns) obtained with \code{\link{betaks}}. \strong{betam} is the
meridional gradient of the absolute vorticity in mercator coordinates}

\item{u}{matrix (longitude = rows x latitude from minor to
major = columns) obtained with \code{\link{betaks}}. Is the zonal wind speed
in the appropriate format for the \code{ray}. It will be converted in mercator
coordinates inside the \code{ray}}

\item{lat}{Numeric vector of latitudes from minor to major
(ex: -90 to 90). Obtained with \code{\link{betaks}}}

\item{x0}{Numeric value. Initial longitude (choose between -180 to 180)}

\item{y0}{Numeric value. Initial latitude}

\item{K}{Numeric value; Total Rossby wavenumber}

\item{dt}{Numeric value; Timestep for integration (hours)}

\item{itime}{Numeric value; total integration time. For instance, 10 days
times 4 times per day}

\item{direction}{Numeric value (possibilities: 1 or -1)
It controls the wave displacement:
If 1, the wave goes to the north of the source;
If -1, the wave goes to the south of the source.}

\item{interpolation}{Character. Set the interpolation method to be used:
\code{\link{trin}} or \code{\link{ypos}}}

\item{tl}{Numeric value; Turning latitude. Do not change this!
It will always start with a positive tl (1) and automatically
change to negative (-1) after the turning latitude}

\item{a}{Earth's radio (m)}

\item{verbose}{Boolean; if TRUE (default) return messages
during compilation}

\item{ofile}{Character;  Output file name with .csv extension,
for instance, "/user/ray.csv"}
}
\value{
sf data.frame
}
\description{
\code{ray} returns the Rossby wave ray paths (lat/lon) triggered from
one initial source/position (x0, y0), one total wavenumber (K), and one
direction set up when invoking the function.
\code{ray} must ingest the meridional gradient of the absolute vorticity
in mercator coordinates\strong{betam}, the zonal mean wind \strong{u},
and the latitude vector (\strong{lat}). Those variables can be obtained
(recommended) using \code{\link{betaks}} function. The zonal means of the
basic state will be calculated along the \strong{ray} program, as well as
the conversion to mercator coordinates of \strong{u}.
}
\examples{
{
# For Coelho et al. (2015):
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                     package = "raytracing")
b <- betaks(u = input)
rt <- ray(betam = b$betam,
          u = b$u,
          lat = b$lat,
          K = 3,
          itime = 10 * 4,
          x0 = -130,
          y0 = -30,
          dt = 6,
          direction = -1,
          interpolation = "trin")
rp <- ray_path(rt$lon, rt$lat)
plot(rp,
     main = "Coelho et al. (2015): JFM/2014",
     axes = TRUE,
     cex = 2,
     graticule = TRUE)
}
}
\seealso{
\code{\link{ray_source}}
}
