% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_entities.R
\name{BlockEntities}
\alias{BlockEntities}
\alias{get_block_entities_data}
\alias{put_block_entities_data}
\title{Load and store BlockEntities NBT data}
\usage{
get_block_entities_data(db, x = get_keys(db), z, dimension)

put_block_entities_data(db, data)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{data}{A named-list of key-value pairs for BlockEntities data.}
}
\description{
BlockEntities data (tag 49) holds a list of NBT values for
entity data associated with specific blocks.

\code{get_block_entities_data()} loads BlockEntities data from a \code{bedrockdb}.
It will silently drop and keys not representing BlockEntities data.

\code{put_block_entities_data()} stores BlockEntities data into a \code{bedrockdb}.
}
