% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{SubchunkBlocks}
\alias{SubchunkBlocks}
\alias{get_subchunk_blocks_data}
\alias{get_subchunk_blocks_value}
\alias{put_subchunk_blocks_data}
\alias{put_subchunk_blocks_values}
\alias{put_subchunk_blocks_value}
\alias{read_subchunk_blocks_value}
\alias{write_subchunk_blocks_value}
\alias{subchunk_origins}
\alias{subchunk_coords}
\title{Load and store SubchunkBlocks data}
\usage{
get_subchunk_blocks_data(
  db,
  x,
  z,
  dimension,
  subchunk,
  names_only = FALSE,
  extra_block = FALSE
)

get_subchunk_blocks_value(
  db,
  x,
  z,
  dimension,
  subchunk,
  names_only = FALSE,
  extra_block = FALSE
)

put_subchunk_blocks_data(db, data)

put_subchunk_blocks_values(db, x, z, dimension, subchunk, values)

put_subchunk_blocks_value(db, x, z, dimension, subchunk, value)

read_subchunk_blocks_value(rawdata, names_only = FALSE, extra_block = FALSE)

write_subchunk_blocks_value(object)

subchunk_origins(keys)

subchunk_coords(ind, origins = subchunk_origins(names(ind)))
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{subchunk}{Subchunk indexes to extract data from.}

\item{names_only}{A logical scalar. Return only the names of the blocks,
ignoring block states.}

\item{extra_block}{A logical scalar. Append the extra block layer to the
output (separated by ";"). This is mostly useful if you have waterlogged
blocks. If the extra block is air, it will not be appended.}

\item{data}{A named list of 16x16x16 character() arrays}

\item{values}{A list of 16x16x16 character() arrays}

\item{value}{A 16x16x16 character array}

\item{rawdata}{a raw vector holding binary SubchunkBlock data}

\item{object}{A 16x16x16 character array.}

\item{keys}{A character vector of database keys.}

\item{ind}{Numeric vector or a named list of numeric vectors containing
indexes for blocks in a subchunk.}

\item{origins}{A matrix of subchunk origins.}
}
\value{
\code{get_subchunk_blocks_data()} returns a list of the of the values
returned by \code{read_subchunk_blocks_value()}.

\code{get_subchunk_blocks_value()} and \code{read_subchunk_blocks_value()}
return a 16x16x16 character array. The axes represent the \code{x}, \code{y}, and \code{z}
dimensions in that order.

\code{read_subchunk_blocks_value()} returns a 16x16x16 character array.
The axes represent the \code{x}, \code{y}, and \code{z} dimensions in that order.

\code{subchunk_coords()} returns a 3-column matrix of block coordinates.
}
\description{
SubchunkBlocks data (tag 47) holds information about the blocks in a
subchunks. Each chunk is divided into multiple 16x16x16 subchunks, and each
subchunk is stored separately and indicated by the use of the subtag.
Blocks are stored in a palette-based format. Subchunks can have two layers
of blocks, and the extra layer is most-often used to store water for
water-logged blocks.

These functions return block data as strings containing the
block name and block states. The strings' format is
\code{blockname@state1=value1@state2=value2} etc.
Blocks may have 0 or more states.

\code{get_subchunk_blocks_data()} loads SubchunkBlocks data from a \code{bedrockdb}.
It will silently drop and keys not representing SubchunkBlocks data.

\code{get_subchunk_blocks_value()} loads SubchunkBlocks data from a \code{bedrockdb}.
It only supports loading a single value.

\code{put_subchunk_blocks_data()}, \code{put_subchunk_blocks_values()}, and
\code{put_subchunk_blocks_value()} store SubchunkBlocks data into a \code{bedrockdb}.

\code{read_subchunk_blocks_value()} decodes binary SubchunkBlock data.

\code{subchunk_origins()} returns a matrix containing the block coordinate of the
lower NW corner of subchunk keys

\code{subchunk_coords()} determines the block coordinates of blocks based on their
array indexes and their subchunk origins.
}
\details{
If a subchunk contains only air it will not be stored in the database, and
missing subchunks are considered air.
}
