% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks-subchunk.R
\name{SubChunkBlocks}
\alias{SubChunkBlocks}
\alias{get_subchunk_blocks_value}
\alias{get_subchunk_blocks_data}
\alias{put_subchunk_blocks_value}
\alias{put_subchunk_blocks_data}
\alias{read_subchunk_blocks_value}
\alias{write_subchunk_blocks_value}
\alias{subchunk_blocks_value_as_array}
\alias{subchunk_blocks_array_as_value}
\alias{subchunk_origins}
\alias{subchunk_coords}
\title{Load and store SubChunkBlocks data}
\usage{
get_subchunk_blocks_value(x, z, dimension, subchunk, db = default_db())

get_subchunk_blocks_data(x, z, dimension, subchunk, db = default_db())

put_subchunk_blocks_value(
  value,
  x,
  z,
  dimension,
  subchunk,
  db = default_db(),
  version = 9L
)

put_subchunk_blocks_data(
  values,
  x,
  z,
  dimension,
  subchunk,
  db = default_db(),
  version = 9L
)

read_subchunk_blocks_value(rawvalue, subchunk_position = NA_integer_)

write_subchunk_blocks_value(value, subchunk_position, version = 9L)

subchunk_blocks_value_as_array(
  value,
  names_only = FALSE,
  extra_block = !names_only
)

subchunk_blocks_array_as_value(r)

subchunk_origins(keys)

subchunk_coords(ind, origins = subchunk_origins(names(ind)))
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{subchunk}{Subchunk indexes}

\item{db}{A bedrockdb object.}

\item{value}{A SubChunkBlocks data value}

\item{version}{Which format of subchunk data to use}

\item{values}{A (named) list of SubChunkBlocks data values. If \code{x} is
missing, the names of \code{values} will be taken as the keys.}

\item{rawvalue}{A raw vector}

\item{subchunk_position}{Optional, an integer. When reading a value, it will
be used if the value's position attribute is missing. When writing a value,
it will be used in place of the value's position attribute.}

\item{names_only}{A logical scalar. Return only the names of the blocks,
ignoring block states.}

\item{extra_block}{A logical scalar. Append the extra block layer to the
output (separated by ";"). This is mostly useful if you have waterlogged
blocks. If the extra block is air, it will not be appended.}

\item{r}{A character array}

\item{keys}{A character vector of keys.}

\item{ind}{Numeric vector or a named list of numeric vectors containing
indexes for blocks in a subchunk.}

\item{origins}{A matrix of subchunk origins.}
}
\value{
\code{get_subchunk_blocks_value()} returns a SubChunkBlocks data value.
\code{get_biomes_data()} returns a named list of SubChunkBlocks data values.
}
\description{
SubChunkBlocks data (tag 47) stores information about the blocks in a world.
Each chunk is divided into multiple 16x16x16 subchunks, and the blocks for
each subchunk are stored separately. Blocks are stored per subchunk in a
palette-based format. Block storage is separated into multiple layers where
each layer has its own block palette and block ids. In practices subchunks
have either one or two layers, and the extra layer is most-often used to
store water for water-logged blocks.
}
\details{
The format description can be found at
\url{https://gist.github.com/Tomcc/a96af509e275b1af483b25c543cfbf37}.
\itemize{
\item \code{get_subchunk_blocks_value()} and \code{get_subchunk_blocks_data()} load
SubChunkBlocks data from \code{db}. \code{get_subchunk_blocks_value()} loads data
for a single subchunk, and \code{get_subchunk_blocks_data()} loads data for
multiple subchunks.
\item \code{put_subchunk_blocks_value()} and \code{put_subchunk_blocks_data()} store
SubChunkBlocks data into \code{db}.
\item \code{write_subchunk_blocks_value()} encodes SubChunkBlocks data into a raw
vector. \code{read_subchunk_blocks_value()} decodes binary SubChunkBlocks data.
\item \code{subchunk_blocks_value_as_array()} converts SubChunkBlocks data into a
character array.
\item \code{subchunk_origins()} returns a matrix containing the block coordinate of
the lower NW corner of subchunk keys.
\item \code{subchunk_coords()} determines the block coordinates of blocks based on
their array indexes and their subchunk origins.
}
}
