% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_namesearch.R
\name{bhl_namesearch}
\alias{bhl_namesearch}
\title{Search for a particular name.}
\usage{
bhl_namesearch(name = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{name}{species name (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Names both with and without NameBank identifiers are returned.
}
\examples{
\dontrun{
bhl_namesearch('poa annua')
bhl_namesearch(name='helianthus annuus')
bhl_namesearch(name='helianthus annuus', as='xml')
bhl_namesearch(name='helianthus annuus', as='json')
}
}

