% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getpagemetadata.R
\name{bhl_getpagemetadata}
\alias{bhl_getpagemetadata}
\title{Return metadata about a page.}
\usage{
bhl_getpagemetadata(
  page = NULL,
  ocr = FALSE,
  names = FALSE,
  as = "table",
  key = NULL,
  ...
)
}
\arguments{
\item{page}{page number to get}

\item{ocr}{return ocr text of the page (\code{TRUE}/\code{FALSE})}

\item{names}{return the names that appear on the page (\code{TRUE}/\code{FALSE})}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
You may choose to include the OCR text and a list of names found on the page
}
\examples{
\dontrun{
bhl_getpagemetadata(page=1328690, ocr=TRUE)
bhl_getpagemetadata(page=1328690, ocr=TRUE, as='json')
bhl_getpagemetadata(page=1328690, ocr=TRUE, as='xml')
bhl_getpagemetadata(page=1328690, ocr=TRUE, as='list')
}
}
